class Health_HealthPack extends HealthPack;

var int HealUpTo;

auto state Pickup
{	
	function Touch( actor Other )
	{
	local Pawn P;
			
	if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
		{	
		P = Pawn(Other);	
		if (P.Health < HealUpTo) 
			{
			P.Health += HealingAmount;
			if (P.Health > HealUpTo)
				{
				P.Health = HealUpTo;
				}
			PlayPickupMessage(P);
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();
			}
		}
	}
}

defaultproperties
{
     HealUpTo=500
     HealingAmount=250
     bSuperHeal=True
     PickupMessage="You picked up the SuperHealthPack, Health +"
     ItemName="Super Health Pack"
     RespawnTime=50.000000
     PickupViewMesh=LodMesh'Botpack.hbox'
     MaxDesireability=2.000000
     PickupSound=Sound'Botpack.Pickups.UTSuperHeal'
     Mesh=LodMesh'Botpack.hbox'
     DrawScale=0.800000
     CollisionRadius=26.000000
     CollisionHeight=19.500000
     MultiSkins(1)=Texture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     MultiSkins(2)=Texture'UnrealShare.Belt_fx.UDamageFX'
}
